if exists("b:current_syntax")
    finish
endif

let s:cs_cpo_save = &cpo
set cpo&vim


" type
syn keyword csType      bool byte char decimal double float
syn keyword csType                      int long object sbyte short string uint
syn keyword csType                      ulong ushort void
" storage
syn keyword csStorage     class delegate enum interface namespace
syn keyword csStorage                   struct
" repeate / condition / label
syn keyword csRepeat      break continue do for foreach goto
syn keyword csRepeat                    return while yield
syn keyword csConditional   else if switch
syn keyword csLabel     case default
" there's no :: operator in C#
syn match csOperatorError   display +::+
" user labels (see [1] 8.6 Statements)
syn match   csLabel     display +^\s*\I\i*\s*:\([^:]\)\@=+
" modifier
syn keyword csModifier      abstract const extern internal override
syn keyword csModifier                  private protected public readonly sealed
syn keyword csModifier                  static virtual volatile partial
" constant
syn keyword csConstant      false null true
" exception
syn keyword csException     try catch finally throw

" TODO:
syn keyword csUnspecifiedStatement  as base checked event fixed in is lock
syn keyword csUnspecifiedStatement      new operator out params ref sizeof
syn keyword csUnspecifiedStatement      stackalloc this typeof unchecked unsafe
syn keyword csUnspecifiedStatement      using
" TODO:
syn keyword csUnsupportedStatement  get set add remove value
" TODO:
syn keyword csUnspecifiedKeyword  explicit implicit where

" Comments
"
" PROVIDES: @csCommentHook
"
" TODO: include strings ?
"
syn region  csComment   start="/\*"  end="\*/" contains=@csCommentHook
syn match   csComment   "//.*$" contains=@csCommentHook

" xml markup inside '///' comments
syn cluster xmlRegionHook add=csXmlCommentLeader
syn cluster xmlCdataHook  add=csXmlCommentLeader
syn cluster xmlStartTagHook add=csXmlCommentLeader
syn keyword csXmlTag    contained c code example exception include list
syn keyword csXmlTag            contained para param paramref permission remarks
syn keyword csXmlTag            contained returns see seealso summary value

syn cluster xmlTagHook add=csXmlTag

syn match   csXmlCommentLeader  +\/\/\/+    contained
syn match   csXmlComment  +\/\/\/.*$+ contains=csXmlCommentLeader,@csXml
syntax include @csXml syntax/xml.vim
hi def link xmlRegion Comment


" [1] 9.5 Pre-processing directives
syn region  csPreCondit
    \ start="^\s*#\s*\(define\|undef\|if\|elif\|else\|endif\|line\|error\|warning\|region\|endregion\)"
    \ skip="\\$" end="$" contains=csComment keepend

" Strings and constants
syn match   csSpecialError  contained "\\."
syn match   csSpecialCharError  contained "[^']"
" [1] 9.4.4.4 Character literals
syn match   csSpecialChar contained +\\["\\'0abfnrtvx]+
" unicode characters
syn match   csUnicodeNumber +\\\(u\x\{4}\|U\x\{8}\)+ contained contains=csUnicodeSpecifier
syn match   csUnicodeSpecifier  +\\[uU]+ contained
syn region  csVerbatimString  start=+@"+ end=+"+ end=+$+ contains=csVerbatimSpec
syn match   csVerbatimSpec  +@"+he=s+1 contained
syn region  csString    start=+"+  end=+"+ end=+$+ contains=csSpecialChar,csSpecialError,csUnicodeNumber
syn match   csCharacter   "'[^']*'" contains=csSpecialChar,csSpecialCharError
syn match   csCharacter   "'\\''" contains=csSpecialChar
syn match   csCharacter   "'[^\\]'"
syn match   csNumber    "\<\(0[0-7]*\|0[xX]\x\+\|\d\+\)[lL]\=\>"
syn match   csNumber    "\(\<\d\+\.\d*\|\.\d\+\)\([eE][-+]\=\d\+\)\=[fFdD]\="
syn match   csNumber    "\<\d\+[eE][-+]\=\d\+[fFdD]\=\>"
syn match   csNumber    "\<\d\+\([eE][-+]\=\d\+\)\=[fFdD]\>"

" The default highlighting.
hi def link csType      Type
hi def link csStorage     StorageClass
hi def link csRepeat      Repeat
hi def link csConditional   Conditional
hi def link csLabel     Label
hi def link csModifier      StorageClass
hi def link csConstant      Constant
hi def link csException     Exception
hi def link csUnspecifiedStatement  Statement
hi def link csUnsupportedStatement  Statement
hi def link csUnspecifiedKeyword  Keyword
hi def link csOperatorError   Error

hi def link csComment     Comment

hi def link csSpecialError    Error
hi def link csSpecialCharError    Error
hi def link csString      String
hi def link csVerbatimString    String
hi def link csVerbatimSpec    SpecialChar
hi def link csPreCondit     PreCondit
hi def link csCharacter     Character
hi def link csSpecialChar   SpecialChar
hi def link csNumber      Number
hi def link csUnicodeNumber   SpecialChar
hi def link csUnicodeSpecifier    SpecialChar

" xml markup
hi def link csXmlCommentLeader    Comment
hi def link csXmlComment    Comment
hi def link csXmlTag      Statement

let b:current_syntax = "cs"

let &cpo = s:cs_cpo_save
unlet s:cs_cpo_save

" vim: ts=8
